package
{
	import com.pokkt.pokktsdk.PokktASExtension;
	import com.pokkt.pokktsdk.PokktEvent;
	import com.pokkt.pokktsdk.PokktOperation;
	
	import flash.events.EventDispatcher;
	
	public class PokktManager extends EventDispatcher
	{
		private static var _instance:PokktManager;
		private var _pokktExtension:PokktASExtension;
		private var _isExtensionAlreadyCreated:Boolean = false;
		
		public static var IsAutoCacheVideo:Boolean;
		
		public function PokktManager(ic:InternalClass)
		{
			if(ic == null)
			{
				throw new Error("Cannot create instance of singleton class of PokktManager, use getInstance() instead");
			}
		}
		
		public static function getInstance():PokktManager
		{
			if(_instance == null)
			{
				return _instance ||= new PokktManager(new InternalClass());
			}
			return _instance;
		}
		
		public function createExtension():void
		{
			if(_isExtensionAlreadyCreated) return;
			
			_isExtensionAlreadyCreated = true;
			_pokktExtension = new PokktASExtension();
		}
		
		public function initPokkt():void
		{
			_pokktExtension.initPokkt();
			addEventListener();
		}
		
		private function addEventListener():void
		{
			_pokktExtension.addEventListener(PokktEvent.DOWNLOAD_COMPLETED_EVENTS, onDownloadCompleted);
			_pokktExtension.addEventListener(PokktEvent.DOWNLOAD_FAILED_EVENTS, onDownloadFailed);
			_pokktExtension.addEventListener(PokktEvent.COIN_RESPONSE_EVENTS, onCoinResponseSuccess);
			_pokktExtension.addEventListener(PokktEvent.COIN_RESPONSE_FAILED_EVENTS, onCoinResponseFailed);
			_pokktExtension.addEventListener(PokktEvent.COIN_RESPONSE_WITH_TRANS_ID_EVENTS, onCoinResponseWithTransID);
			_pokktExtension.addEventListener(PokktEvent.OFFERWALL_CAMPAIGN_AVAILABLITY_EVENT, onOfferwallAvailability);
			_pokktExtension.addEventListener(PokktEvent.OFFERWALL_CLOSE_EVENT, onOfferwallClosed);
			_pokktExtension.addEventListener(PokktEvent.VIDEO_CLOSED_EVENTS, onVideoClosed);
			_pokktExtension.addEventListener(PokktEvent.VIDEO_COMPLETED_EVENTS, onVideoCompleted);
			_pokktExtension.addEventListener(PokktEvent.VIDEO_SKIPPED_EVENTS, onVideoSkipped);
			_pokktExtension.addEventListener(PokktEvent.VIDEO_DISPLAYED_EVENTS, onVideoDisplayed);
			_pokktExtension.addEventListener(PokktEvent.VIDEO_GRATIFIED_EVENTS, onVideoGratified);
			
			//these are the sample setter which can be call according to need. There are more. So use it accordingly.
			/*_pokktExtension.performOperation(PokktOperation.SET_THIRD_PARTY_USER_ID, "123456");
			_pokktExtension.performOperation(PokktOperation.SET_SEX, "Male","WHite","abcd");
			_pokktExtension.performOperation(PokktOperation.SET_THE_LOCATION, "Bangalore");*/
		}
		
		public function get pokktExtension():PokktASExtension
		{
			return _pokktExtension;
		}
		
		public function setParams(securityKey:String, applicationID:String, userID:String, integrationType:String, autoCache:String):void
		{
			_pokktExtension.setParams(securityKey, applicationID, userID, integrationType, autoCache);
		}
		
		//Callback functions
		protected function onVideoGratified(event:PokktEvent):void
		{
			showLog(event);
			dispatchEvent(new PokktEvent(PokktEvent.VIDEO_GRATIFIED_EVENTS, event.value));
		}
		
		protected function onVideoDisplayed(event:PokktEvent):void
		{
			showLog(event);
			dispatchEvent(new PokktEvent(PokktEvent.VIDEO_DISPLAYED_EVENTS, event.value));
		}
		
		protected function onVideoSkipped(event:PokktEvent):void
		{
			showLog(event);
			dispatchEvent(new PokktEvent(PokktEvent.VIDEO_SKIPPED_EVENTS, event.value));
		}
		
		protected function onVideoCompleted(event:PokktEvent):void
		{
			showLog(event);
			dispatchEvent(new PokktEvent(PokktEvent.VIDEO_COMPLETED_EVENTS, event.value));
		}
		
		protected function onVideoClosed(event:PokktEvent):void
		{
			showLog(event);
			dispatchEvent(new PokktEvent(PokktEvent.VIDEO_CLOSED_EVENTS, event.value));
		}
		
		protected function onCoinResponseWithTransID(event:PokktEvent):void
		{
			showLog(event);
			//split the string which is separated by comma(,); It has transaction id and earned points
			var finalValue:Array = event.value.split(",");
			trace("Transaction ID: " + finalValue[0] + " and Earned points: " + finalValue[1]);
			dispatchEvent(new PokktEvent(PokktEvent.COIN_RESPONSE_WITH_TRANS_ID_EVENTS, event.value));
		}
		
		protected function onCoinResponseSuccess(event:PokktEvent):void
		{
			showLog(event);
			dispatchEvent(new PokktEvent(PokktEvent.COIN_RESPONSE_EVENTS, event.value));
		}
		
		protected function onCoinResponseFailed(event:PokktEvent):void
		{
			showLog(event);
			dispatchEvent(new PokktEvent(PokktEvent.COIN_RESPONSE_FAILED_EVENTS, event.value));
		}
		
		protected function onOfferwallAvailability(event:PokktEvent):void
		{
			showLog(event);
			dispatchEvent(new PokktEvent(PokktEvent.OFFERWALL_CAMPAIGN_AVAILABLITY_EVENT, event.value));
		}
		
		protected function onOfferwallClosed(event:PokktEvent):void
		{
			showLog(event);
			dispatchEvent(new PokktEvent(PokktEvent.OFFERWALL_CLOSE_EVENT, event.value));
		}
		
		protected function onDownloadCompleted(event:PokktEvent):void
		{
			showLog(event);
			dispatchEvent(new PokktEvent(PokktEvent.DOWNLOAD_COMPLETED_EVENTS, event.value));
		}
		
		protected function onDownloadFailed(event:PokktEvent):void
		{
			showLog(event);
			dispatchEvent(new PokktEvent(PokktEvent.DOWNLOAD_FAILED_EVENTS, event.value));
		}
		
		
		//Functions which can call from outside
		public function playVideoIncent(screenName:String):void
		{
			_pokktExtension.performOperation(PokktOperation.GET_VIDEO,screenName);
		}
		
		public function playVideoNonIncent(screenName:String):void
		{
			_pokktExtension.performOperation(PokktOperation.GET_VIDEO_NON_INCENT,screenName);
		}
		
		public function playVideoWithoutIntent(screenName:String):void
		{
			_pokktExtension.performOperation(PokktOperation.GET_VIDEO_WITH_INTENT,screenName);
		}
		
		public function getFreeCoins():void
		{
			_pokktExtension.performOperation(PokktOperation.GET_FREE_COINS);
		}
		
		public function getFixedFreeCoins(value:String):void
		{
			_pokktExtension.performOperation(PokktOperation.GET_FIXED_FREE_COINS_FROM_POKKT, value);
		}
		
		public function getPendingCoins():void
		{
			_pokktExtension.performOperation(PokktOperation.GET_PENDING_COINS);
		}
		
		public function checkTransaction():void
		{
			_pokktExtension.performOperation(PokktOperation.CHECK_TRANSACTION);
		}
		
		public function setDefaultSkipTime(value:int):void
		{
			_pokktExtension.setDefaultSkipTime(value);
		}
		
		public function showToast(text:String):void
		{
			_pokktExtension.showToast(text);
		}
		
		public function setDebug(value:Boolean):void
		{
			_pokktExtension.setDebug(value);
		}
		
		public function showLog(event:PokktEvent):void
		{
			_pokktExtension.showLogs("SampleProject: Event received type " + event.type + ", event.value: " + event.value);
		}
		
		public function IsVideoAvailable():Boolean
		{
			return _pokktExtension.isVideoAvailablePokkt();
		}
		
		public function IsOfferwallCampaignAvailable():Boolean
		{
			return _pokktExtension.performOperation(PokktOperation.CHECK_CAMPAIGN_AVAILABLITY);
		}
		
		public function startCaching():void
		{
			_pokktExtension.performOperation(PokktOperation.START_CACHING_VIDEO);
		}
		
		public function setThirdPartyUserId(value:String):void
		{
			_pokktExtension.performOperation(PokktOperation.SET_THIRD_PARTY_USER_ID, value);
		}
		
	}
}

internal class InternalClass{}